// convert x3d
// m.miller 03.09.2023


#include "shapes3.inc"  
#include "needle_nose_plyer/needle_nose_plyer_materials.inc"

//--- screw driver handle
#declare handle_A =
sphere_sweep {
     cubic_spline
     9,
     <-18.738, -40.838, 0.000> , 2.710
     <-18.738, -40.838, 0.000> , 2.710
     <-18.927, -34.613, 0.000> , 2.710
     <-17.757, -27.533, 0.000> , 2.710
     <-14.304, -20.686, 0.000> , 2.710
     <-9.799, -15.127, 0.000> , 2.571
     <-6.522, -11.382, 0.000> , 2.571
     <-3.484, -8.125, 0.000> , 2.571
     <-3.484, -8.125, 0.000> , 2.571
     tolerance 0.000001
     }

//--- screw driver handle
#declare handle_B =
sphere_sweep {
     cubic_spline
     9,
     <-18.738, -40.838, 0.000> , 2.310
     <-18.738, -40.838, 0.000> , 2.310
     <-18.927, -34.613, 0.000> , 2.310
     <-17.757, -27.533, 0.000> , 2.310
     <-14.304, -20.686, 0.000> , 2.310
     <-9.799, -15.127, 0.000> , 2.171
     <-6.522, -11.382, 0.000> , 2.171
     <-3.484, -8.125, 0.000> , 2.171
     <-3.484, -8.125, 0.000> , 2.171
     tolerance 0.000001
     }


//--- handle metal
#declare metal_A =
sphere_sweep {
     cubic_spline
     7,
     <-1.755, -1.004, 0.000> , 2.421
     <-1.755, -1.004, 0.000> , 2.421
     <-2.289, -4.682, 0.000> , 2.021
     <-3.647, -8.125, 0.000> , 2.021
     <-6.522, -11.382, 0.000> , 2.011
     <-9.799, -15.127, 0.000> , 2.046
     <-9.799, -15.127, 0.000> , 2.046
     tolerance 0.000001
     }


//--- plyer nose
#declare nose =
    sphere_sweep {
         cubic_spline
         7,
         <-0.000, 2.167, 0.000> , 2.951
         <-0.000, 2.167, 0.000> , 2.951
         <-0.000, 6.515, 0.000> , 2.951
         <-0.000, 9.603, 0.000> , 2.951
         <-0.000, 17.446, 0.000> , 1.891
         <-0.000, 29.122, 0.000> , 0.566
         <-0.000, 29.122, 0.000> , 0.566
         tolerance 0.000001
         }
            
    
#declare Z_cut=1.3; 


#macro make_needle_nose_plyer(open_angle, Typ)  
    #switch (Typ)
        #case (1)
            #declare M_grip =  M_black_rubber_grip;
        #break
        
        #case (2)
            #declare M_grip =  M_red_rubber;
        #break 
    
        #case (3)
            #declare M_grip =  M_blue_gloss;
        #break  
     #end

    //--- plyer handles
    #declare plyer_half = 
    union { 
        union {
            union {
                //---black grip            
                difference {
                    object {handle_A scale <.8,1,1>}
                    plane {<0,-1,0>,0 translate <0,-13,0>} 
                    material {M_grip scale <.051,.051,.051>}
                }    
                
                //---yellow grip detail
                difference {
                    object {handle_B scale <.8,1,1>}
                    plane {<0,-1,0>,0 translate <0,-11,0>} 
                    material {M_yellow_gloss}
                } 
                
                //---lower metal handle 
                difference {
                    object {metal_A scale <.8,1,1>}
                    plane { <0,0,1>, 0 translate <0,0,-Z_cut> }  
                    plane { <0,0,-1>, 0 translate <0,0,Z_cut> }
                    plane { <0,-1,0>, 0 translate <0,-1,0> }  
                    plane { <-1,0,0>, 0 rotate <0,0,-12> translate <-.15,0,0> }
                    cylinder {<0,0,5>,<0,0,-5>,3.5 }
                    material {M_steel_oxidized  scale <.5,.5,.5>} 
                    }
                   rotate <0,0,12>
                   }
                rotate <0,0,-open_angle> 
           }
        
        
        //---nose    
        difference { 
            object {nose}
            plane { <0,0,1>, 0 translate <0,0,-Z_cut-.5> }  
            plane { <0,0,-1>, 0 translate <0,0,Z_cut+.5> }
            plane { <0,-1,0>, -29.1 }
            plane { <-1,0,0>, 0 }
            #declare sc = <.8, 2.800, .8> ;
            #declare rad = .15 ; 
            object { box { <-.5,-.5,-.5> * sc, <.5,.5,.5> *sc } scale <1,2,4> translate <-0.000, 6.000,  1.35> } 
            object { box { <-.5,-.5,-.5> * sc, <.5,.5,.5> *sc } scale <1,2,2> translate <-0.000, 6.000, -1.25> } 
            cylinder {<0,0,-Z_cut>,<0,0,Z_cut>,3.45 } 
            material {M_steel_oxidized  scale <.5,.5,.5> }
            scale <1.1,1,.65>
            rotate <0,0,open_angle> 
        }    
    }     
          
    //--- plyer 
    union {
        difference {
            union {
                object {plyer_half scale <1,1,1.1>}  
                object {plyer_half scale <-1,1,1.1>}
                }
                object { cylinder {<0,0,-Z_cut>,<0,0,Z_cut>,3.45 } }
        }    
        object { Round_Cylinder(<0,0,-Z_cut>, <0,0,Z_cut>, 2 , 0.20,   0) }
        object{ Rounded_Tube_AB( <0,0,-Z_cut>, <0,0,Z_cut>, 3.45, 2, 0.2,1)  }
        sphere {<0,0,0>,1 scale <1,1,.2> translate <0,0,-Z_cut>} 
        sphere {<0,0,0>,1 scale <1,1,.2> translate <0,0,Z_cut>} 
        material {M_steel_oxidized  scale <.5,.5,.5> }
    }
 
#end    